####################################################
### code chunk number : Simulations: Consistency
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
ptm = proc.time()

## initialization
alpha = 3            ## hyperparameter
beta = 2             ## hyperparameter
# N = 1e4 * 2^c(1, 2, 4, 8); N      ## sample size
N = 1e4 * 2^c(0, 1, 2, 3); N      ## sample size
L_N = length(N); L_N ## the length of N
M = 100; M           ## number of simulations

# set.seed(2)
n = N[L_N]
X = matrix(0, nrow = M, ncol = n)
for (m in 1:M){
	set.seed(m)
	theta_m = 1 / rgamma(n = n, shape = alpha, scale = 1/beta)
	X[m, ] = rexp(n = n, rate = 1/theta_m)
}

## Histogram,
hist(X[1, ], probability = TRUE,
     main = paste("Histogram of" , "X[1, ]"), 
     xlab = "x")
lines(density(X[1, ]), col = "blue")

Matrix_LN_M = matrix(0, nrow = L_N, ncol = M)
alpha_1 = beta_1 = Matrix_LN_M
alpha_2 = beta_2 = Matrix_LN_M
Index_MLE_warning_error = Matrix_LN_M
Iter = Norm = Matrix_LN_M
for (j in 1:L_N){
	n = N[j]
	alpha_1_beta_1 = alpha_2_beta_2 = matrix(0, nrow = M, ncol = 2)
	for (m in 1:M){
		cat("\n"); print(paste("In this cycle, j = ", j, ", m = ", m, sep = "")); cat("\n")

		## Note that x is the sample, it is used in the calculation of the MLEs. 
		## See moment_fun().
		x = X[m, 1:n]
		alpha_1_beta_1[m, ] =  Moment_estimators_EX_EX2(x)
		cat("alpha_1_beta_1[m, ] \n"); print(alpha_1_beta_1[m, ]); cat("\n")

		## The MLE is very sensitive to the initial guess. 
		## The moment estimator is usually a good initial guess.
		alpha_2_beta_2[m, ] = tryCatch ( {
			res_Newtons_m = Newtons(fun = moment_fun, y = alpha_1_beta_1[m, ])
			Iter[j, m] = res_Newtons_m$it
			Norm[j, m] = res_Newtons_m$norm
			res_Newtons_m$root
		} , warning = function ( w ) {
			alpha_1_beta_1[m, ]
		} , error = function ( e ) {
			alpha_1_beta_1[m, ]
		} , finally = {
			""
		}
		)
		cat("alpha_2_beta_2[m, ] \n"); print(alpha_2_beta_2[m, ]); cat("\n")

		if (all(alpha_2_beta_2[m, ] == alpha_1_beta_1[m, ])){
			cat("\n alpha_2_beta_2[m, ] = alpha_1_beta_1[m, ]\n")
			Index_MLE_warning_error[j, m] = 1
		}
	}
	alpha_1[j, ] = alpha_1_beta_1[, 1]
	beta_1[j, ]  = alpha_1_beta_1[, 2]

	alpha_2[j, ] = alpha_2_beta_2[, 1]
	beta_2[j, ]  = alpha_2_beta_2[, 2]
}
Iter
Norm

## display the Index
Index_MLE_warning_error
rowSums(Index_MLE_warning_error)
sum(Index_MLE_warning_error)

## calculate absolute error 
Abs_alpha_1 = abs(alpha_1 - matrix(alpha, nrow = L_N, ncol = M)); # round(Abs_alpha_1, 3)
Abs_beta_1  = abs(beta_1 - matrix(beta, nrow = L_N, ncol = M)); # round(Abs_beta_1, 3)

Abs_alpha_2 = abs(alpha_2 - matrix(alpha, nrow = L_N, ncol = M)); ## round(Abs_alpha_2, 3)
Abs_beta_2  = abs(beta_2 - matrix(beta, nrow = L_N, ncol = M)); ## round(Abs_beta_2, 3)

## 
## calculate the frequencies
## 

## moment estimator
F = matrix(0, nrow = 12, ncol = 4)
F1 = F2 = matrix(0, nrow = L_N, ncol = 2)
colnames(F1) = c("alpha_1", "beta_1")
colnames(F2) = c("alpha_2", "beta_2")

epsilon = 1
F1[, 1] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 2] = apply((Abs_beta_1  >= epsilon), 1, mean)
F[1:4, 1:2] = F1
round(F1, 3)

epsilon = 0.5
F1[, 1] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 2] = apply((Abs_beta_1  >= epsilon), 1, mean)
F[5:8, 1:2] = F1
round(F1, 3)

epsilon = 0.1
F1[, 1] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 2] = apply((Abs_beta_1  >= epsilon), 1, mean)
F[9:12, 1:2] = F1
round(F1, 3)

## MLE
epsilon = 1
F2[, 1] = apply((Abs_alpha_2 >= epsilon), 1, mean)
F2[, 2] = apply((Abs_beta_2  >= epsilon), 1, mean)
F[1:4, 3:4] = F2
round(F2, 3)

epsilon = 0.5
F2[, 1] = apply((Abs_alpha_2 >= epsilon), 1, mean)
F2[, 2] = apply((Abs_beta_2  >= epsilon), 1, mean)
F[5:8, 3:4] = F2
round(F2, 3)

epsilon = 0.1
F2[, 1] = apply((Abs_alpha_2 >= epsilon), 1, mean)
F2[, 2] = apply((Abs_beta_2  >= epsilon), 1, mean)
F[9:12, 3:4] = F2
round(F2, 3)

round(F, 2)
Generate_Matrix_Latex(format(F, nsmall = 2))

time_new = proc.time() - ptm; time_new

